package ru.yandex.partner.core.entity.block.type.base;

import java.util.Map;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.service.validation.defects.BlockDefects;
import ru.yandex.partner.core.entity.page.model.PageWithOwner;

@Component
public class PageReachabilityValidator {

    public <M extends BaseBlock> Validator<M, Defect> validator(Map<Long, ? extends PageWithOwner> reachablePages) {
        return block -> {
            ModelItemValidationBuilder<M> vb = ModelItemValidationBuilder.of(block);

            vb.item(BaseBlock.PAGE_ID)
                    .check(pageId -> reachablePages.containsKey(pageId) ? null : BlockDefects.pageUnreachable(pageId),
                            When.notNull());

            return vb.getResult();
        };
    }
}
