package ru.yandex.partner.core.entity.block.type.blocktype;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.springframework.stereotype.Service;

import ru.yandex.partner.core.block.MobileBlockType;


@Service
public class BlockTypesService {

    private final Map<String, BlockTypeDto> map = Arrays.stream(MobileBlockType.values())
            .map(MobileBlockType::getLiteral)
            .collect(Collectors.toMap(
                    Function.identity(),
                    id -> new BlockTypeDto().withId(id)
            ));

    public Set<String> getTypeIds() {
        return map.keySet();
    }

    /**
     * https://github.yandex-team.ru/partner/partner2/blob/0ca44028ec0404296b6c5f59fb9b12ffc11f939a/lib/Application/Model/Product/AN/MobileApp/BlockTypes/Settings.pm#L71
     */
    public static final class BlockTypeDto {
        private String id;
        // todo: add other fields when necessary

        public BlockTypeDto withId(String id) {
            this.id = id;
            return this;
        }

        public String getId() {
            return id;
        }
    }
}
