package ru.yandex.partner.core.entity.block.type.blocktype;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithBlockType;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.partner.dbschema.partner.tables.ContextOnSiteRtb.CONTEXT_ON_SITE_RTB;

@Component
@ParametersAreNonnullByDefault
public class BlockWithBlockTypeRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithBlockType> {
    private final JooqMapper<BlockWithBlockType> mapper;

    @Autowired
    protected BlockWithBlockTypeRepositoryTypeSupport(
            DSLContext dslContext
    ) {
        super(dslContext);
        this.mapper = JooqMapperBuilder.<BlockWithBlockType>builder()
                .map(property(BlockWithBlockType.BLOCK_TYPE, CONTEXT_ON_SITE_RTB.BLOCK_TYPE))
                .build();
    }
    @Override
    public JooqMapper<BlockWithBlockType> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithBlockType> getTypeClass() {
        return BlockWithBlockType.class;
    }
}
