package ru.yandex.partner.core.entity.block.type.blocktype;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithBlockType;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;

@Component
public class BlockWithBlockTypeValidationTypeSupport
        extends AbstractBlockValidationTypeSupport<BlockWithBlockType> {
    private final Validator<BlockWithBlockType, Defect> validator;

    @Autowired
    public BlockWithBlockTypeValidationTypeSupport(
            BlockWithBlockTypeValidatorProvider validatorProvider
    ) {
        this.validator = validatorProvider.validator();
    }

    @Override
    public Class<BlockWithBlockType> getTypeClass() {
        return BlockWithBlockType.class;
    }

    @Override
    public ValidationResult<List<BlockWithBlockType>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithBlockType>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }
}

