package ru.yandex.partner.core.entity.block.type.blocktype;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.constraint.StringConstraints;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithBlockType;
import ru.yandex.partner.core.entity.block.service.validation.defects.BlockDefectIds;

import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Component
public class BlockWithBlockTypeValidatorProvider {

    private final BlockTypesService blockTypesService;

    public BlockWithBlockTypeValidatorProvider(BlockTypesService blockTypesService) {
        this.blockTypesService = blockTypesService;
    }

    public <M extends BlockWithBlockType> Validator<M, Defect> validator() {
        return block -> {
            ModelItemValidationBuilder<M> vb = ModelItemValidationBuilder.of(block);
            vb.item(BlockWithBlockType.BLOCK_TYPE)
                    .check(StringConstraints.maxStringLength(18))
                    .check(notNull())
                    .check(fromPredicate(
                            t -> blockTypesService.getTypeIds().contains(t),
                            new Defect<>(BlockDefectIds.BlockTypeDefects.INVALID_BLOCK_TYPE_VALUE)
                    ));

            return vb.getResult();
        };
    }
}
