package ru.yandex.partner.core.entity.block.type.blocktypeanddsps;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.block.MobileBlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithBlockTypeAndDsps;
import ru.yandex.partner.core.entity.block.service.validation.defects.BlockDefectIds;
import ru.yandex.partner.core.entity.dsp.model.Dsp;
import ru.yandex.partner.core.entity.dsp.multistate.DspMultistateGraph;
import ru.yandex.partner.core.entity.dsp.rules.DspRule;
import ru.yandex.partner.core.entity.dsp.rules.DspRuleComponent;
import ru.yandex.partner.core.entity.dsp.rules.DspRuleContainer;
import ru.yandex.partner.core.entity.dsp.rules.DspRuleSet;
import ru.yandex.partner.core.entity.dsp.rules.result.DspRuleResult;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.multistate.Multistate;
import ru.yandex.partner.core.multistate.dsp.DspStateFlag;

import static ru.yandex.partner.core.CoreConstants.DSP_DIRECT_ID;
import static ru.yandex.partner.core.CoreConstants.DspFormats;
import static ru.yandex.partner.core.entity.block.model.prop.BlockWithDspsDspsPropHolder.DSPS;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;
import static ru.yandex.partner.dbschema.partner.Tables.DSP;
import static ru.yandex.partner.dbschema.partner.Tables.DSP_FORMAT;
import static ru.yandex.partner.libs.multistate.MultistatePredicates.has;

public abstract class BlockWithBlockTypeAndDspsRules extends DspRuleComponent<BlockWithBlockTypeAndDsps> {

    private final List<Long> workingOnAllPlatformsMultistates;

    public BlockWithBlockTypeAndDspsRules(DspMultistateGraph dspMultistateGraph) {
        this.workingOnAllPlatformsMultistates = dspMultistateGraph
                .getMultistatesForPredicate(has(workingOnAllPlatformsStateFlag()))
                .stream()
                .map(Multistate::toMultistateValue)
                .collect(Collectors.toList());
    }

    // задел для внутренних мобилок
    protected abstract DspStateFlag workingOnAllPlatformsStateFlag();

    @Override
    public Class<BlockWithBlockTypeAndDsps> getEntireTypeClass() {
        return null;
    }

    @Override
    public DspRuleSet getDspRuleSet(DspRuleContainer container) {
        return new DspRuleSet()
                .withRule(
                        new DspRule<BasePage, BlockWithBlockTypeAndDsps, Dsp>() {
                            @Override
                            public DspRuleResult defaultDsps(DspRuleContainer dspRuleContainer, BasePage page,
                                                             BlockWithBlockTypeAndDsps block) {
                                if (MobileBlockType.NATIVE.hasType(block)) {
                                    return DspRuleResult.extend(
                                            DSP_FORMAT.FORMAT_ID.eq(DspFormats.NATIVE)
                                                    .and(DSP.MULTISTATE.in(workingOnAllPlatformsMultistates))
                                    );
                                } else {
                                    return DspRuleResult.limitIdentity();
                                }
                            }

                            @Override
                            public DspRuleResult availableDsps(DspRuleContainer dspRuleContainer,
                                                               BlockWithBlockTypeAndDsps block) {
                                if (MobileBlockType.NATIVE.hasType(block)) {
                                    return DspRuleResult.extend(DSP_FORMAT.FORMAT_ID.eq(DspFormats.NATIVE));
                                } else {
                                    return DspRuleResult.limitIdentity();
                                }
                            }

                            @Override
                            public DspRuleResult turnOnDsps(DspRuleContainer dspRuleContainer, BasePage page,
                                                            BlockWithBlockTypeAndDsps block, Dsp dsp) {
                                if (Objects.nonNull(dsp.getFormats()) &&
                                        dsp.getFormats().contains(DspFormats.NATIVE)) {
                                    return DspRuleResult.extend(CONTEXT_ON_SITE_RTB.BLOCK_TYPE
                                            .eq(MobileBlockType.NATIVE.getLiteral()));
                                } else {
                                    return DspRuleResult.extendZero();
                                }
                            }
                        }
                )
                .withRule(
                        new DspRule<BasePage, BlockWithBlockTypeAndDsps, Dsp>() {
                            @Override
                            public DspRuleResult availableDsps(DspRuleContainer dspRuleContainer,
                                                               BlockWithBlockTypeAndDsps block) {
                                if (MobileBlockType.ADAPTIVE_BANNER.hasType(block)) {
                                    return DspRuleResult.extend(DSP.ID.eq(DSP_DIRECT_ID));
                                } else {
                                    return DspRuleResult.limitIdentity();
                                }
                            }

                            @Override
                            public DspRuleResult defaultDsps(DspRuleContainer dspRuleContainer, BasePage page,
                                                             BlockWithBlockTypeAndDsps block) {
                                if (MobileBlockType.ADAPTIVE_BANNER.hasType(block)) {
                                    return DspRuleResult.extend(DSP.ID.eq(DSP_DIRECT_ID));
                                } else {
                                    return DspRuleResult.limitIdentity();
                                }
                            }

                            @Override
                            public DspRuleResult turnOnDsps(DspRuleContainer dspRuleContainer, BasePage page,
                                                            BlockWithBlockTypeAndDsps block, Dsp dsp) {
                                if (dsp.getId() == DSP_DIRECT_ID) {
                                    return DspRuleResult.limitIdentity();
                                } else {
                                    return DspRuleResult.limit(CONTEXT_ON_SITE_RTB.BLOCK_TYPE
                                            .ne(MobileBlockType.ADAPTIVE_BANNER.getLiteral()));
                                }
                            }

                            @Override
                            public ValidationResult<BlockWithBlockTypeAndDsps, Defect> dspsFieldValidation(
                                    DspRuleContainer dspRuleContainer, BlockContainer container,
                                    ValidationResult<BlockWithBlockTypeAndDsps, Defect> vr) {
                                return new ItemValidationBuilder<>(vr)
                                        .checkBy(block -> validateBlock(block))
                                        .getResult();
                            }
                        }
                );
    }

    public ValidationResult<BlockWithBlockTypeAndDsps, Defect> validateBlock(BlockWithBlockTypeAndDsps block) {
        ModelItemValidationBuilder<BlockWithBlockTypeAndDsps> vb =
                ModelItemValidationBuilder.of(block);
        vb.item(DSPS).checkByFunction(it -> {
            List<Dsp> dsps = it;
            if (MobileBlockType.ADAPTIVE_BANNER.hasType(block)
                    && !(dsps.size() == 1
                    && dsps.get(0).getId() == DSP_DIRECT_ID)) {
                return new Defect<>(BlockDefectIds
                        .DspBlocks
                        .INVALID_DSP_BLOCK_TYPES);
            }
            return null;
        });
        return vb.getResult();
    }
}
