package ru.yandex.partner.core.entity.block.type.blocktypeanddsps

import ru.yandex.partner.core.CoreConstants.DSP_DIRECT_ID
import ru.yandex.partner.core.CoreConstants.DspFormats
import ru.yandex.partner.core.CoreConstants.DspTypes
import ru.yandex.partner.core.block.MobileBlockType
import ru.yandex.partner.core.entity.block.model.BlockWithBlockTypeAndDsps
import ru.yandex.partner.core.entity.dsp.model.Dsp
import ru.yandex.partner.core.entity.dsp.multistate.DspMultistateGraph
import ru.yandex.partner.core.entity.dsp.rules.DspRule
import ru.yandex.partner.core.entity.dsp.rules.DspRuleComponent
import ru.yandex.partner.core.entity.dsp.rules.DspRuleContainer
import ru.yandex.partner.core.entity.dsp.rules.DspRuleSet
import ru.yandex.partner.core.entity.dsp.rules.result.DspRuleResult
import ru.yandex.partner.core.entity.page.model.BasePage
import ru.yandex.partner.core.multistate.dsp.DspStateFlag
import ru.yandex.partner.dbschema.partner.Tables.DSP
import ru.yandex.partner.dbschema.partner.Tables.DSP_TYPE
import ru.yandex.partner.dbschema.partner.tables.ContextOnSiteRtb
import ru.yandex.partner.dbschema.partner.tables.DspFormat.DSP_FORMAT

abstract class BlockWithBlockTypeDspsRewardedRules(
    dspMultistateGraph: DspMultistateGraph,
    workingOnAllPlatformsStateFlag: DspStateFlag,
    val workingOnAllPlatformsMultistates: List<Long> = dspMultistateGraph
        .getMultistatesForPredicate(workingOnAllPlatformsStateFlag)
        .map { it.toMultistateValue() }
        .toList()
) : DspRuleComponent<BlockWithBlockTypeAndDsps>() {
    override fun getEntireTypeClass(): Class<BlockWithBlockTypeAndDsps>? {
        return null
    }

    override fun getDspRuleSet(container: DspRuleContainer): DspRuleSet {
        return DspRuleSet()
            .withRule(object : DspRule<BasePage, BlockWithBlockTypeAndDsps, Dsp>() {
                override fun defaultDsps(
                    dspRuleContainer: DspRuleContainer,
                    page: BasePage,
                    block: BlockWithBlockTypeAndDsps
                ): DspRuleResult {
                    return if (block.blockType.equals(MobileBlockType.REWARDED.literal)) {
                        DspRuleResult.extend(
                            DSP.ID.eq(DSP_DIRECT_ID)
                                .or(dspTypeJoinCondition()
                                    .and(DSP_TYPE.TYPE_ID.eq(DspTypes.DSP_MOBILE.typeId))
                                    .and(dspFormatJoinCondition())
                                    .and(DSP_FORMAT.FORMAT_ID.eq(DspFormats.VIDEO))
                                    .and(DSP.MULTISTATE.`in`(workingOnAllPlatformsMultistates))
                                )
                        )
                    } else {
                        DspRuleResult.limitIdentity()
                    }
                }

                override fun availableDsps(
                    dspRuleContainer: DspRuleContainer,
                    block: BlockWithBlockTypeAndDsps
                ): DspRuleResult {
                    return if (block.blockType.equals(MobileBlockType.REWARDED.literal)) {
                        DspRuleResult.extend(
                            dspFormatJoinCondition()
                                .and(DSP_FORMAT.FORMAT_ID.eq(DspFormats.BANNER)
                                    .or(dspTypeJoinCondition()
                                        .and(DSP_TYPE.TYPE_ID.eq(DspTypes.DSP_MOBILE.typeId))
                                        .and(DSP_FORMAT.FORMAT_ID.eq(DspFormats.VIDEO))
                                    )
                                )
                        )
                    } else {
                        DspRuleResult.limitIdentity()
                    }
                }

                override fun turnOnDsps(
                    dspRuleContainer: DspRuleContainer, page: BasePage,
                    block: BlockWithBlockTypeAndDsps, dsp: Dsp
                ): DspRuleResult {
                    return if (dsp.id == DSP_DIRECT_ID ||
                        (dsp.types.contains(DspTypes.DSP_MOBILE.typeId) && dsp.formats.contains(DspFormats.VIDEO))) {
                        DspRuleResult.extend(
                            ContextOnSiteRtb.CONTEXT_ON_SITE_RTB.BLOCK_TYPE
                                .eq(MobileBlockType.REWARDED.literal)
                        )
                    } else {
                        DspRuleResult.extendZero()
                    }
                }
            })
    }

    private fun dspFormatJoinCondition() = DSP.ID.eq(DSP_FORMAT.DSP_ID)
    private fun dspTypeJoinCondition() = DSP.ID.eq(DSP_TYPE.DSP_ID)
}
