package ru.yandex.partner.core.entity.block.type.blocktypeandshowslider;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import NPartner.Page;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.block.BlockUniqueIdConverter;
import ru.yandex.partner.core.block.MobileBlockType;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithBlockTypeAndShowSlider;
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller;
import ru.yandex.partner.core.entity.block.type.designtemplates.BlockWithDesignTemplatesBkDataHelper;

import static ru.yandex.partner.core.CoreConstants.BK_SLIDER_VALUE;


@Component
@ParametersAreNonnullByDefault
public class BlockWithBlockTypeAndShowSliderBkFiller implements BlockBkFiller<BlockWithBlockTypeAndShowSlider> {

    private final ObjectMapper objectMapper;

    @Autowired
    protected BlockWithBlockTypeAndShowSliderBkFiller(
            ObjectMapper objectMapper
    ) {
        this.objectMapper = objectMapper;
    }
    @Override
    public Class<BlockWithBlockTypeAndShowSlider> getTypeClass() {
        return BlockWithBlockTypeAndShowSlider.class;
    }

    @Override
    public void fillBkData(@NotNull BlockWithBlockTypeAndShowSlider model,
                           @NotNull Page.TPartnerPage.TBlock.Builder bkData, BlockBkDictContainer container) {
        String blockType = model.getBlockType();
        bkData.setBlockType(blockType);

        if (MobileBlockType.INTERSTITIAL.hasType(model)) {
            bkData.setInterstitialBlock(true);
        }

        String publicId = BlockUniqueIdConverter.convertToPublicId(model.getId());

        // Мапка id дизайна -> его значение
        // В ПИ дизайн известен как design_templates. Для БК они лежат в поле RtbDesign (нет суффикса s, хотя коллекция)
        Map<Long, Map<String, Object>> rtbDesign = Maps.newHashMapWithExpectedSize(1);
        Map<String, Object> designSettings = new HashMap<>();
        designSettings.put("blockId", publicId);
        designSettings.put("name", MobileBlockType.BANNER.hasType(model) ? "adaptive0418" : model.getBlockType());

        designSettings.put("limit", calcLimit(model));

        var designId = 0L;
        var designValue = new HashMap<>(Map.of(
                "name", "",
                "design", designSettings // стоит обратить внимание, что по полю "design" хранятся настройки
        ));
        rtbDesign.put(designId, designValue);

        if (MobileBlockType.NATIVE.hasType(model) && Boolean.TRUE.equals(model.getShowSlider())) {
            designValue.put("slider", BK_SLIDER_VALUE);
        }

        bkData.setRtbDesign(toJson(rtbDesign));

        // На поле AllowedImageTypes БК не смотрит с 2017 года https://st.yandex-team.ru/BSDEV-63940
        // TODO: нужно удалить
        BlockWithDesignTemplatesBkDataHelper.fillAllowedImageTypes(bkData);

    }


    private String toJson(Map<Long, Map<String, Object>> bkDesign) {
        try {
            return objectMapper.writeValueAsString(bkDesign);
        } catch (JsonProcessingException e) {
            throw new RuntimeException("Error during serialize to json.", e);
        }
    }

    private Integer calcLimit(BlockWithBlockTypeAndShowSlider model) {
        if (MobileBlockType.NATIVE.hasType(model)) {
            return Objects.requireNonNullElse(model.getLimit(), 1);
        } else {
            return 1;
        }
     }
}
