package ru.yandex.partner.core.entity.block.type.blocktypeandshowslider;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithBlockTypeAndShowSlider;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;

@Component
public class BlockWithBlockTypeAndShowSliderValidationTypeSupport
        extends AbstractBlockValidationTypeSupport<BlockWithBlockTypeAndShowSlider> {
    private final Validator<BlockWithBlockTypeAndShowSlider, Defect> validator;

    @Autowired
    public BlockWithBlockTypeAndShowSliderValidationTypeSupport(
            BlockWithBlockTypeAndShowSliderValidatorProvider validatorProvider
    ) {
        this.validator = validatorProvider.validator();
    }

    @Override
    public Class<BlockWithBlockTypeAndShowSlider> getTypeClass() {
        return BlockWithBlockTypeAndShowSlider.class;
    }

    @Override
    public ValidationResult<List<BlockWithBlockTypeAndShowSlider>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithBlockTypeAndShowSlider>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }
}

