package ru.yandex.partner.core.entity.block.type.blocktypeandshowslider;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithBlockTypeAndShowSlider;
import ru.yandex.partner.core.entity.block.type.blocktype.BlockTypesService;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Component
public class BlockWithBlockTypeAndShowSliderValidatorProvider {

    private final BlockTypesService blockTypesService;

    public BlockWithBlockTypeAndShowSliderValidatorProvider(BlockTypesService blockTypesService) {
        this.blockTypesService = blockTypesService;
    }

    public <M extends BlockWithBlockTypeAndShowSlider> Validator<M, Defect> validator() {
        return block -> {
            ModelItemValidationBuilder<M> vb = ModelItemValidationBuilder.of(block);
            if (Boolean.TRUE.equals(block.getShowSlider())) {
                vb.item(BlockWithBlockTypeAndShowSlider.LIMIT)
                        .check(notNull());
            }

            return vb.getResult();
        };
    }
}
