package ru.yandex.partner.core.entity.block.type.blocktypeandshowslider;

import java.util.List;
import java.util.Optional;
import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithBlockTypeAndShowSlider;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.entity.block.type.showslider.BlockWithShowSliderRepositoryTypeSupport;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

import static ru.yandex.partner.core.entity.block.model.prop.MobileRtbBlockLimitPropHolder.LIMIT;
import static ru.yandex.partner.core.entity.block.model.prop.MobileRtbBlockShowSliderPropHolder.SHOW_SLIDER;


@Component
public class BlockWithShowSliderUpdateOperationTypeSupport extends
        AbstractBlockUpdateOperationTypeSupport<BlockWithBlockTypeAndShowSlider> {

    public BlockWithShowSliderUpdateOperationTypeSupport(
            PartnerRepositoryTypeSupportFacade<BaseBlock, BlockType, BlockContainer, BlockContainer> repositoryFacade) {
        super(repositoryFacade);
    }

    @Override
    public Class<BlockWithBlockTypeAndShowSlider> getTypeClass() {
        return BlockWithBlockTypeAndShowSlider.class;
    }

    @Override
    public Set<ModelProperty<? super BlockWithBlockTypeAndShowSlider, ?>> needBsResyncProps() {
        return Set.of(SHOW_SLIDER, LIMIT);
    }

    @Override
    public void onChangesApplied(BlockContainer updateContainer,
                                 List<AppliedChanges<BlockWithBlockTypeAndShowSlider>> appliedChanges) {
        for (AppliedChanges<BlockWithBlockTypeAndShowSlider> changes : appliedChanges) {
            if (changes.changed(SHOW_SLIDER) && changes.getNewValue(SHOW_SLIDER) != null && !changes.changed(LIMIT)) {
                if (changes.getNewValue(SHOW_SLIDER)) {
                    changes.modify(LIMIT, Optional.ofNullable(changes.getOldValue(LIMIT))
                            .orElse(BlockWithShowSliderRepositoryTypeSupport.DEFAULT_LIMIT));
                } else {
                    changes.modify(LIMIT, null);
                }
            }
        }
    }
}
