package ru.yandex.partner.core.entity.block.type.brands;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithBrands;
import ru.yandex.partner.core.entity.block.service.type.add.AbstractBlockAddOperationTypeSupport;
import ru.yandex.partner.core.entity.common.utils.ModelWithBlockPageIdsUtils;

@Component
public class BlockWithBrandsAddOperationTypeSupport
        extends AbstractBlockAddOperationTypeSupport<BlockWithBrands> {
    @Override
    public Class<BlockWithBrands> getTypeClass() {
        return BlockWithBrands.class;
    }

    @Override
    public void onDuplicate(BlockContainer addModelContainer, List<BlockWithBrands> models) {
        models.forEach(it -> {
            if (it.getBrands() != null) {
                it.getBrands().forEach(brand -> brand.setId(null));
                ModelWithBlockPageIdsUtils.clearPageBlockIds(it.getBrands());
            }
        });
    }

    @Override
    public void beforeExecution(BlockContainer addContainer, List<BlockWithBrands> models) {
        models.forEach(it -> ModelWithBlockPageIdsUtils.setPageBlockIds(it.getBrands(), it, addContainer.getMode()));
    }
}
