package ru.yandex.partner.core.entity.block.type.brands;

import java.util.List;
import java.util.Set;
import java.util.function.Function;

import javax.annotation.Nonnull;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithBrands;
import ru.yandex.partner.core.entity.block.model.Brand;
import ru.yandex.partner.core.entity.block.model.prop.RtbBlockBrandsPropHolder;
import ru.yandex.partner.core.validation.ModelWithDictEntriesListValidator;

public class BlockWithBrandsListValidator extends ModelWithDictEntriesListValidator<BlockWithBrands, Brand> {

    private final BrandValidatorProvider brandValidatorProvider;

    public BlockWithBrandsListValidator(BrandValidatorProvider brandValidatorProvider, Set<Long> existingBrandIds) {
        super(existingBrandIds);

        this.brandValidatorProvider = brandValidatorProvider;
    }

    @Override
    protected void validateModel(ModelItemValidationBuilder<BlockWithBrands> vb) {
        vb.list(getModelPropertyToCheck()).checkEachBy(brandValidatorProvider.brandValidator());
    }

    @Override
    protected ModelProperty<RtbBlockBrandsPropHolder, List<Brand>> getModelPropertyToCheck() {
        return BlockWithBrands.BRANDS;
    }

    @Override
    @Nonnull
    protected Function<Brand, Long> idGetter() {
        return Brand::getBid;
    }
}
