package ru.yandex.partner.core.entity.block.type.brands;

import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithBrands;
import ru.yandex.partner.core.entity.block.model.Brand;
import ru.yandex.partner.core.entity.common.validation.ModelWithBlockPageIdValidatorProvider;
import ru.yandex.partner.core.entity.common.validation.NullPropertiesValidatorProvider;

@Component
public class BlockWithBrandsValidatorProvider {

    private final BrandValidatorProvider brandValidatorProvider;
    private final ModelWithBlockPageIdValidatorProvider<Brand> modelWithBlockPageIdValidatorProvider;
    private final NullPropertiesValidatorProvider<Brand> nullPropertiesValidatorProvider;

    @Autowired
    public BlockWithBrandsValidatorProvider(BrandValidatorProvider brandValidatorProvider,
                                            ModelWithBlockPageIdValidatorProvider<Brand>
                                                    modelWithBlockPageIdValidatorProvider,
                                            NullPropertiesValidatorProvider<Brand> nullPropertiesValidatorProvider) {
        this.brandValidatorProvider = brandValidatorProvider;
        this.modelWithBlockPageIdValidatorProvider = modelWithBlockPageIdValidatorProvider;
        this.nullPropertiesValidatorProvider = nullPropertiesValidatorProvider;
    }

    public Validator<List<BlockWithBrands>, Defect> validator(Set<Long> existingBrandIds) {
        return new BlockWithBrandsListValidator(brandValidatorProvider, existingBrandIds);
    }

    public Validator<BlockWithBrands, Defect> addPreValidator() {
        return block -> {
            var vb = ModelItemValidationBuilder.of(block);
            vb.list(BlockWithBrands.BRANDS)
                    .checkEachBy(nullPropertiesValidatorProvider.addPreValidator(List.of(Brand.ID)))
                    .checkEachBy(modelWithBlockPageIdValidatorProvider.addPreValidator());
            return vb.getResult();
        };
    }
}
