package ru.yandex.partner.core.entity.block.type.closebuttondelay;

import javax.annotation.ParametersAreNonnullByDefault;

import NPartner.Page.TPartnerPage;
import com.fasterxml.jackson.databind.node.LongNode;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.block.MobileBlockType;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithBlockType;
import ru.yandex.partner.core.entity.block.model.BlockWithBlockTypeAndCloseButtonDelay;
import ru.yandex.partner.core.entity.block.model.BlockWithCloseButtonDelay;
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller;
import ru.yandex.partner.core.entity.custombkoptions.CustomBkOptionsService;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.ChangePredicate;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;

@Component
@ParametersAreNonnullByDefault
public class BlockWithBlockTypeAndCloseButtonDelayModelProviderAndBkFiller
        implements BlockBkFiller<BlockWithBlockTypeAndCloseButtonDelay>,
        CoreModelProvider<BlockWithBlockTypeAndCloseButtonDelay> {
    private final CustomBkOptionsService customBkOptionsService;

    public static final Long DEFAULT_CLOSE_BUTTON_DELAY_VALUE = 2L;

    public static final CoreModel<BlockWithBlockTypeAndCloseButtonDelay> MODEL =
            CoreModel.forClass(BlockWithBlockTypeAndCloseButtonDelay.class)
                    .property(
                            ModelPropertyDefault.<BlockWithBlockTypeAndCloseButtonDelay, String>
                                            forProperty(BlockWithBlockType.BLOCK_TYPE)
                                    .withDefaultValue(MobileBlockType.BANNER.getLiteral())
                    )
                    .dependentPropertiesWhen(
                            ChangePredicate.havingPropertyValue(
                                    BlockWithBlockType.BLOCK_TYPE, MobileBlockType.INTERSTITIAL.getLiteral()
                            ),
                            configuration -> configuration
                                    .property(ModelPropertyDefault.<BlockWithBlockTypeAndCloseButtonDelay, Long>
                                                    forProperty(BlockWithCloseButtonDelay.CLOSE_BUTTON_DELAY)
                                            .optional()
                                            .withDefaultValueOnAdd(DEFAULT_CLOSE_BUTTON_DELAY_VALUE)
                                    )
                    ).build();

    public BlockWithBlockTypeAndCloseButtonDelayModelProviderAndBkFiller(
            CustomBkOptionsService customBkOptionsService
    ) {
        this.customBkOptionsService = customBkOptionsService;
    }


    @Override
    public Class<BlockWithBlockTypeAndCloseButtonDelay> getTypeClass() {
        return BlockWithBlockTypeAndCloseButtonDelay.class;
    }

    @Override
    public void fillBkData(
            @NotNull BlockWithBlockTypeAndCloseButtonDelay model,
            @NotNull TPartnerPage.TBlock.Builder bkData,
            BlockBkDictContainer container
    ) {
        if (MobileBlockType.INTERSTITIAL.getLiteral().equals(model.getBlockType())) {
            String customBlockData = customBkOptionsService.set(
                    bkData.getCustomBlockData(),
                    "close-button-delay",
                   LongNode.valueOf(model.getCloseButtonDelay())
            );
            bkData.setCustomBlockData(customBlockData);
        }
    }

    @Override
    public CoreModel<BlockWithBlockTypeAndCloseButtonDelay> getCoreModel() {
        return MODEL;
    }
}
