package ru.yandex.partner.core.entity.block.type.closebuttondelay;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders;
import ru.yandex.partner.core.entity.block.model.BlockWithCloseButtonDelay;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.multitype.repository.EmptyTypeSupportModifyStrategy;
import ru.yandex.partner.dbschema.partner.tables.ContextOnSiteRtb;

@Component
@ParametersAreNonnullByDefault
public class BlockWithCloseButtonDelayRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithCloseButtonDelay> {
    private final JooqMapper<BlockWithCloseButtonDelay> mapper;

    @Autowired
    protected BlockWithCloseButtonDelayRepositoryTypeSupport(
            DSLContext dslContext
    ) {
        super(dslContext, new EmptyTypeSupportModifyStrategy<>());
        this.mapper = JooqMapperBuilder.<BlockWithCloseButtonDelay>builder()
                .map(
                        JsonReaderWriterBuilders.jsonLong(
                                BlockWithCloseButtonDelay.CLOSE_BUTTON_DELAY,
                                ContextOnSiteRtb.CONTEXT_ON_SITE_RTB.OPTS,
                                "close_button_delay"
                        )
                )
                .build();
    }
    @Override
    public JooqMapper<BlockWithCloseButtonDelay> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithCloseButtonDelay> getTypeClass() {
        return BlockWithCloseButtonDelay.class;
    }
}
