package ru.yandex.partner.core.entity.block.type.closebuttondelay;

import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithCloseButtonDelay;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

@Component
public class BlockWithCloseButtonDelayUpdateOperationTypeSupport extends
        AbstractBlockUpdateOperationTypeSupport<BlockWithCloseButtonDelay> {

    public BlockWithCloseButtonDelayUpdateOperationTypeSupport(
            PartnerRepositoryTypeSupportFacade<BaseBlock, BlockType, BlockContainer, BlockContainer> repositoryFacade) {
        super(repositoryFacade);
    }

    @Override
    public Class<BlockWithCloseButtonDelay> getTypeClass() {
        return BlockWithCloseButtonDelay.class;
    }

    @Override
    public Set<ModelProperty<? super BlockWithCloseButtonDelay, ?>> needBsResyncProps() {
        return Set.of(BlockWithCloseButtonDelay.CLOSE_BUTTON_DELAY);
    }
}
