package ru.yandex.partner.core.entity.block.type.closebuttondelay;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithCloseButtonDelay;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;

@Component
public class BlockWithCloseButtonDelayValidationTypeSupport
        extends AbstractBlockValidationTypeSupport<BlockWithCloseButtonDelay> {
    private final Validator<BlockWithCloseButtonDelay, Defect> validator;

    @Autowired
    public BlockWithCloseButtonDelayValidationTypeSupport(
            BlockWithCloseButtonDelayValidatorProvider validatorProvider
    ) {
        this.validator = validatorProvider.validator();
    }

    @Override
    public Class<BlockWithCloseButtonDelay> getTypeClass() {
        return BlockWithCloseButtonDelay.class;
    }

    @Override
    public ValidationResult<List<BlockWithCloseButtonDelay>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithCloseButtonDelay>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }
}
