package ru.yandex.partner.core.entity.block.type.closebuttondelay;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithCloseButtonDelay;

import static ru.yandex.partner.core.validation.constraints.PartnerNumberConstraints.isIntegerNumberLessThanOrEqual;
import static ru.yandex.partner.core.validation.constraints.PartnerNumberConstraints.isZeroOrGreaterIntegerNumber;

@Component
public class BlockWithCloseButtonDelayValidatorProvider {

    public static final Long MAX_CLOSE_BUTTON_DELAY = 15L;

    public <M extends BlockWithCloseButtonDelay> Validator<M, Defect> validator() {
        return block -> {
            ModelItemValidationBuilder<M> vb = ModelItemValidationBuilder.of(block);
            vb.item(BlockWithCloseButtonDelay.CLOSE_BUTTON_DELAY)
                    .check(isZeroOrGreaterIntegerNumber())
                    .check(isIntegerNumberLessThanOrEqual(MAX_CLOSE_BUTTON_DELAY));

            return vb.getResult();
        };
    }
}
