package ru.yandex.partner.core.entity.block.type.common

import org.springframework.context.MessageSource
import org.springframework.context.support.MessageSourceAccessor
import org.springframework.stereotype.Component
import ru.yandex.partner.core.entity.block.container.BlockContainer
import ru.yandex.partner.core.entity.block.model.BlockWithCommonFields
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock
import ru.yandex.partner.core.entity.block.service.type.add.AbstractBlockAddOperationTypeSupport
import ru.yandex.partner.core.messages.ModelTypeMsg

@Component
class BlockWithCommonFieldsAddOperationTypeSupport(
    messageSource: MessageSource
) : AbstractBlockAddOperationTypeSupport<BlockWithCommonFields>() {
    private val messages = MessageSourceAccessor(messageSource)

    override fun getTypeClass() = BlockWithCommonFields::class.java

    override fun onPreValidated(addContainer: BlockContainer?, models: MutableList<BlockWithCommonFields>) {
        models.forEach {
            if (it.caption == null && it is MobileRtbBlock) {
                // TODO generic solution for default captions on add
                it.caption = messages.getMessage(ModelTypeMsg.MOBILE_RTB_BLOCK)
            }
        }
    }
}
