package ru.yandex.partner.core.entity.block.type.common;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import NPartner.Page.TPartnerPage;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithCommonFields;
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.partner.core.entity.block.model.prop.BlockWithCommonFieldsCaptionPropHolder.CAPTION;
import static ru.yandex.partner.core.entity.block.model.prop.BlockWithCommonFieldsCommentPropHolder.COMMENT;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
@ParametersAreNonnullByDefault
public class BlockWithCommonFieldsRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithCommonFields>
        implements CoreModelProvider<BlockWithCommonFields>, BlockBkFiller<BlockWithCommonFields> {
    private static final CoreModel<BlockWithCommonFields> DEFAULT_VALUES =
            CoreModel.forClass(BlockWithCommonFields.class)
                    .property(ModelPropertyDefault.<BlockWithCommonFields, String>forProperty(COMMENT)
                            .optional().withDefaultValue("")
                    )
                    .build();

    private final JooqMapper<BlockWithCommonFields> mapper;

    @Autowired
    protected BlockWithCommonFieldsRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        this.mapper = createCommonBlockMapper();
    }

    private static JooqMapper<BlockWithCommonFields> createCommonBlockMapper() {
        return JooqMapperBuilder.<BlockWithCommonFields>builder()
                .map(property(CAPTION, CONTEXT_ON_SITE_RTB.CAPTION))
                .map(property(COMMENT, CONTEXT_ON_SITE_RTB.COMMENT))
                .build();
    }

    @Override
    public JooqMapper<BlockWithCommonFields> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithCommonFields> getTypeClass() {
        return BlockWithCommonFields.class;
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<BlockWithCommonFields> blocks) {
    }

    @Override
    public CoreModel<BlockWithCommonFields> getCoreModel() {
        return DEFAULT_VALUES;
    }

    @Override
    public void fillBkData(@NotNull BlockWithCommonFields block,
                           @NotNull TPartnerPage.TBlock.Builder bkData,
                           @NotNull BlockBkDictContainer container) {
        bkData.setBlockCaption(block.getCaption());
    }
}
