package ru.yandex.partner.core.entity.block.type.common;

import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithCommonFields;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

@Component
public class BlockWithCommonFieldsUpdateOperationTypeSupport
        extends AbstractBlockUpdateOperationTypeSupport<BlockWithCommonFields> {

    private static final Set<ModelProperty<? super BlockWithCommonFields, ?>> NEED_UPDATE_IN_BK_FIELDS =
            Set.of(BlockWithCommonFields.CAPTION);

    public BlockWithCommonFieldsUpdateOperationTypeSupport(PartnerRepositoryTypeSupportFacade<BaseBlock, BlockType,
            BlockContainer, BlockContainer> repositoryFacade) {
        super(repositoryFacade);
    }

    @Override
    public Class<BlockWithCommonFields> getTypeClass() {
        return BlockWithCommonFields.class;
    }

    @Override
    public Set<ModelProperty<? super BlockWithCommonFields, ?>> needBsResyncProps() {
        return NEED_UPDATE_IN_BK_FIELDS;
    }
}
