package ru.yandex.partner.core.entity.block.type.common;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithCommonFields;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;

@Component
public class BlockWithCommonFieldsValidateTypeSupport
        extends AbstractBlockValidationTypeSupport<BlockWithCommonFields> {

    private final Validator<BlockWithCommonFields, Defect> validator;

    public BlockWithCommonFieldsValidateTypeSupport(BlockWithCommonFieldsValidatorProvider validatorProvider) {
        this.validator = validatorProvider.validator();
    }

    @Override
    public Class<BlockWithCommonFields> getTypeClass() {
        return BlockWithCommonFields.class;
    }

    @Override
    public ValidationResult<List<BlockWithCommonFields>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithCommonFields>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }
}
