package ru.yandex.partner.core.entity.block.type.common;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithCommonFields;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;
import static ru.yandex.direct.validation.constraint.StringConstraints.minStringLength;
import static ru.yandex.partner.core.entity.block.service.validation.defects.BlockDefects.nullBlockId;
import static ru.yandex.partner.core.entity.block.service.validation.defects.BlockDefects.nullId;
import static ru.yandex.partner.core.entity.block.service.validation.defects.BlockDefects.nullPageId;
import static ru.yandex.partner.core.validation.defects.TypeDefects.invalidTypeMustBeDefined;

@Component
public class BlockWithCommonFieldsValidatorProvider {

    public <M extends BlockWithCommonFields> Validator<M, Defect> validator() {
        return block -> {
            ModelItemValidationBuilder<M> vb = ModelItemValidationBuilder.of(block);
            vb.item(BlockWithCommonFields.ID).check(notNull(), nullId());
            vb.item(BlockWithCommonFields.PAGE_ID).check(notNull(), nullPageId());
            vb.item(BlockWithCommonFields.BLOCK_ID).check(notNull(), nullBlockId());
            vb.item(BlockWithCommonFields.CAPTION)
                    .check(notNull(), invalidTypeMustBeDefined())
                    .check(minStringLength(1))
                    .check(maxStringLength(255));
            return vb.getResult();
        };
    }
}
