package ru.yandex.partner.core.entity.block.type.commonshowvideo;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithCommonShowVideo;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.utils.CommonConverters;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
@ParametersAreNonnullByDefault
public class BlockWithCommonShowVideoRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithCommonShowVideo> {
    private final JooqMapper<BlockWithCommonShowVideo> mapper;

    @Autowired
    protected BlockWithCommonShowVideoRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        this.mapper = createCommonBlockMapper();
    }

    private static JooqMapper<BlockWithCommonShowVideo> createCommonBlockMapper() {
        return JooqMapperBuilder.<BlockWithCommonShowVideo>builder()
                .map(convertibleProperty(BlockWithCommonShowVideo.SHOW_VIDEO, CONTEXT_ON_SITE_RTB.SHOW_VIDEO,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .build();
    }

    @Override
    public JooqMapper<BlockWithCommonShowVideo> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithCommonShowVideo> getTypeClass() {
        return BlockWithCommonShowVideo.class;
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<BlockWithCommonShowVideo> blocks) {
    }
}
