package ru.yandex.partner.core.entity.block.type.commonshowvideo;

import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithCommonShowVideo;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

@Component
public class BlockWithCommonShowVideoUpdateOperationTypeSupport extends
        AbstractBlockUpdateOperationTypeSupport<BlockWithCommonShowVideo> {

    public BlockWithCommonShowVideoUpdateOperationTypeSupport(
            PartnerRepositoryTypeSupportFacade<BaseBlock, BlockType, BlockContainer, BlockContainer> repositoryFacade) {
        super(repositoryFacade);
    }

    @Override
    public Class<BlockWithCommonShowVideo> getTypeClass() {
        return BlockWithCommonShowVideo.class;
    }

    @Override
    public Set<ModelProperty<? super BlockWithCommonShowVideo, ?>> needBsResyncProps() {
        return Set.of(BlockWithCommonShowVideo.SHOW_VIDEO);
    }
}
