package ru.yandex.partner.core.entity.block.type.commonshowvideo;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithCommonShowVideo;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;

@Component
public class BlockWithCommonShowVideoValidationTypeSupport
        extends AbstractBlockValidationTypeSupport<BlockWithCommonShowVideo> {
    private final Validator<BlockWithCommonShowVideo, Defect> validator;

    public BlockWithCommonShowVideoValidationTypeSupport(BlockWithCommonShowVideoValidatorProvider validatorProvider) {
        this.validator = validatorProvider.validator();
    }

    @Override
    public Class<BlockWithCommonShowVideo> getTypeClass() {
        return BlockWithCommonShowVideo.class;
    }

    @Override
    public ValidationResult<List<BlockWithCommonShowVideo>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithCommonShowVideo>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }
}
