package ru.yandex.partner.core.entity.block.type.commonshowvideo;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithCommonShowVideo;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Component
public class BlockWithCommonShowVideoValidatorProvider {

    public <M extends BlockWithCommonShowVideo> Validator<M, Defect> validator() {
        return block -> {
            ModelItemValidationBuilder<M> vb
                    = ModelItemValidationBuilder.of(block);
            vb.item(BlockWithCommonShowVideo.SHOW_VIDEO)
                    .check(notNull());
            return vb.getResult();
        };
    }

}
