package ru.yandex.partner.core.entity.block.type.commonshowvideo

import NPartner.Page.TPartnerPage
import org.springframework.stereotype.Component
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer
import ru.yandex.partner.core.entity.block.model.BlockWithDesignTemplatesAndCommonShowVideo
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller
import ru.yandex.partner.dbschema.partner.enums.DesignTemplatesType

@Component
class BlockWithDesignTemplatesAndCommonShowVideoBkFiller : BlockBkFiller<BlockWithDesignTemplatesAndCommonShowVideo> {
    override fun fillBkData(
        block: BlockWithDesignTemplatesAndCommonShowVideo,
        bkData: TPartnerPage.TBlock.Builder,
        container: BlockBkDictContainer
    ) {
        if (block.showVideo && block.designTemplates?.any { it.type == DesignTemplatesType.video } == true) {
            bkData.videoBuilder.maxDuration = 60
        }
    }

    override fun getTypeClass(): Class<BlockWithDesignTemplatesAndCommonShowVideo> {
        return BlockWithDesignTemplatesAndCommonShowVideo::class.java
    }


}
