package ru.yandex.partner.core.entity.block.type.commonshowvideo;

import java.util.Objects;

import javax.annotation.Nullable;

import org.springframework.stereotype.Service;

import static ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy.SiteVersionType.AMP;
import static ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy.SiteVersionType.TURBO_DESKTOP;

@Service
public class ShowVideoApplicableService {

    public boolean isShowVideoApplicableBySiteVersion(@Nullable String siteVersion, @Nullable Boolean showVideo) {
        return !AMP.getLiteral().equals(siteVersion) &&
                (!TURBO_DESKTOP.getLiteral().equals(siteVersion) || Objects.equals(showVideo, Boolean.TRUE));
    }

    public boolean getDefaultValueBySiteVersion(@Nullable String siteVersion) {
        // для всех ртб default 0
        return false;
    }

}
