package ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.block.model.BlockWithCommonShowVideoAndStrategy;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupport;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportWithoutMapper;
import ru.yandex.partner.core.holder.ModelPropertiesHolder;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;

import static ru.yandex.partner.core.CoreConstants.Strategies.SEPARATE_CPM_STRATEGY_ID;
import static ru.yandex.partner.core.entity.block.model.prop.BlockWithCommonShowVideoShowVideoPropHolder.SHOW_VIDEO;
import static ru.yandex.partner.core.entity.block.model.prop.BlockWithStrategyStrategyTypePropHolder.STRATEGY_TYPE;
import static ru.yandex.partner.core.holder.ModelPropertiesHolder.fromModelProperties;
import static ru.yandex.partner.core.props.ChangePredicate.havingPropertyValue;

@Component
@ParametersAreNonnullByDefault
public class BlockWithCommonShowVideoAndStrategyRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupport<BlockWithCommonShowVideoAndStrategy>
        implements BlockRepositoryTypeSupportWithoutMapper<BlockWithCommonShowVideoAndStrategy>,
        CoreModelProvider<BlockWithCommonShowVideoAndStrategy> {

    public static final CoreModel<BlockWithCommonShowVideoAndStrategy> MODEL =
            CoreModel.forClass(BlockWithCommonShowVideoAndStrategy.class)
                    .dependentPropertiesWhen(
                            havingPropertyValue(STRATEGY_TYPE, SEPARATE_CPM_STRATEGY_ID),
                            configuration -> {
                                configuration.property(BlockWithCommonShowVideoAndStrategy.VIDEO_ACTIVE);
                                configuration.property(BlockWithCommonShowVideoAndStrategy.VIDEO_CPM);
                                configuration.property(BlockWithCommonShowVideoAndStrategy.VIDEO_BLOCKED);
                            }
                    )
                  .dependentPropertiesWhen(
                            havingPropertyValue(SHOW_VIDEO,
                                  Boolean.TRUE),
                          configuration -> {
                              configuration.property(BlockWithCommonShowVideoAndStrategy.VIDEO_ACTIVE);
                              configuration.property(BlockWithCommonShowVideoAndStrategy.VIDEO_CPM);
                              configuration.property(BlockWithCommonShowVideoAndStrategy.VIDEO_BLOCKED);
                          })
                    .build();

    public BlockWithCommonShowVideoAndStrategyRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    public Set<ModelProperty<? super BlockWithCommonShowVideoAndStrategy, ?>> getAffectedModelProperties() {
        return Set.of(
                SHOW_VIDEO
        );
    }

    @Override
    public ModelPropertiesHolder getEditableModelProperties(BlockWithCommonShowVideoAndStrategy model) {
        ModelPropertiesHolder holder = new ModelPropertiesHolder();
        if (Boolean.TRUE.equals(model.getShowVideo())) {
            return fromModelProperties(
                    Set.of(BlockWithCommonShowVideoAndStrategy.VIDEO_ACTIVE,
                            BlockWithCommonShowVideoAndStrategy.VIDEO_CPM,
                            BlockWithCommonShowVideoAndStrategy.VIDEO_BLOCKED)
            );
        }

        return holder;
        // todo хочется чтобы работало так
        // return getCoreModel().resolveEditableProperties(model);
    }

    @Override
    public Class<BlockWithCommonShowVideoAndStrategy> getTypeClass() {
        return BlockWithCommonShowVideoAndStrategy.class;
    }

    @Override
    public CoreModel<BlockWithCommonShowVideoAndStrategy> getCoreModel() {
        return MODEL;
    }
}
