package ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithCommonShowVideoAndStrategy;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;

@Component
public class BlockWithCommonShowVideoAndStrategyValidateTypeSupport
        extends AbstractBlockValidationTypeSupport<BlockWithCommonShowVideoAndStrategy> {
    private final Validator<BlockWithCommonShowVideoAndStrategy, Defect> validator;

    public BlockWithCommonShowVideoAndStrategyValidateTypeSupport(
            BlockWithCommonShowVideoAndStrategyValidatorProvider validatorProvider) {
        this.validator = validatorProvider.validator();
    }

    @Override
    public Class<BlockWithCommonShowVideoAndStrategy> getTypeClass() {
        return BlockWithCommonShowVideoAndStrategy.class;
    }

    @Override
    public ValidationResult<List<BlockWithCommonShowVideoAndStrategy>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithCommonShowVideoAndStrategy>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }
}
