package ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.block.model.BlockWithCommonShowVideoAndStrategy;
import ru.yandex.partner.core.entity.block.model.BlockWithStrategy;
import ru.yandex.partner.core.entity.block.service.validation.defects.BlockDefectIds;
import ru.yandex.partner.core.entity.block.service.validation.defects.StrategyDefectParams;
import ru.yandex.partner.core.validation.constraints.PartnerNumberConstraints;

import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;
import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.NumberConstraints.inRange;
import static ru.yandex.partner.core.CoreConstants.MAX_CPM;
import static ru.yandex.partner.core.CoreConstants.MIN_CPM;
import static ru.yandex.partner.core.CoreConstants.Strategies.MAX_REVENUE_STRATEGY_ID;
import static ru.yandex.partner.core.CoreConstants.Strategies.MIN_CPM_STRATEGY_ID;
import static ru.yandex.partner.core.CoreConstants.Strategies.SEPARATE_CPM_STRATEGY_ID;

@Component
public class BlockWithCommonShowVideoAndStrategyValidatorProvider {

    private final Set<Long> allowedTypes = Set.of(CoreConstants.Strategies.MIN_CPM_STRATEGY_ID,
            CoreConstants.Strategies.MAX_REVENUE_STRATEGY_ID,
            CoreConstants.Strategies.SEPARATE_CPM_STRATEGY_ID);

    public BlockWithCommonShowVideoAndStrategyValidatorProvider() {
        super();
    }

    public <M extends BlockWithCommonShowVideoAndStrategy> Validator<M, Defect> validator() {
        return block -> {
            ModelItemValidationBuilder<M> vbOfBlock = ModelItemValidationBuilder.of(block);
            vbOfBlock.item(BlockWithStrategy.STRATEGY_TYPE)
                    .check(notNull())
                    .check(inSet(allowedTypes), new Defect<>(BlockDefectIds.Strategy.INCORRECT_STRATEGY_VALUE));

            if (MIN_CPM_STRATEGY_ID.equals(block.getStrategyType())) {
                var defect = new Defect<>(BlockDefectIds.Strategy.MINCPM_VALUE_RANGE,
                        new StrategyDefectParams().withMaxCpm(MAX_CPM));
                vbOfBlock.item(BlockWithStrategy.MINCPM)
                        .check(notNull(), defect)
                        .check(inRange(BigDecimal.ZERO, MAX_CPM), defect, When.isValid())
                        .check(PartnerNumberConstraints.maxScale(CoreConstants.CPM_MAX_SCALE), defect);

                vbOfBlock.item(BlockWithStrategy.MEDIA_ACTIVE).check(isNull());
                vbOfBlock.item(BlockWithStrategy.MEDIA_BLOCKED).check(isNull());
                vbOfBlock.item(BlockWithStrategy.MEDIA_CPM).check(isNull());
                vbOfBlock.item(BlockWithStrategy.TEXT_ACTIVE).check(isNull());
                vbOfBlock.item(BlockWithStrategy.TEXT_BLOCKED).check(isNull());
                vbOfBlock.item(BlockWithStrategy.TEXT_CPM).check(isNull());
                vbOfBlock.item(BlockWithStrategy.VIDEO_ACTIVE).check(isNull());
                vbOfBlock.item(BlockWithStrategy.VIDEO_BLOCKED).check(isNull());
                vbOfBlock.item(BlockWithStrategy.VIDEO_CPM).check(isNull());

            } else if (MAX_REVENUE_STRATEGY_ID.equals(block.getStrategyType())) {


                vbOfBlock.item(BlockWithStrategy.MINCPM).check(isNull());
                vbOfBlock.item(BlockWithStrategy.MEDIA_ACTIVE).check(isNull());
                vbOfBlock.item(BlockWithStrategy.MEDIA_BLOCKED).check(isNull());
                vbOfBlock.item(BlockWithStrategy.MEDIA_CPM).check(isNull());
                vbOfBlock.item(BlockWithStrategy.TEXT_ACTIVE).check(isNull());
                vbOfBlock.item(BlockWithStrategy.TEXT_BLOCKED).check(isNull());
                vbOfBlock.item(BlockWithStrategy.TEXT_CPM).check(isNull());
                vbOfBlock.item(BlockWithStrategy.VIDEO_ACTIVE).check(isNull());
                vbOfBlock.item(BlockWithStrategy.VIDEO_BLOCKED).check(isNull());
                vbOfBlock.item(BlockWithStrategy.VIDEO_CPM).check(isNull());


            } else if (SEPARATE_CPM_STRATEGY_ID.equals(block.getStrategyType())) {

                var isVideoAllowed = Boolean.TRUE.equals(block.getShowVideo());

                vbOfBlock.item(BlockWithStrategy.MINCPM).check(isNull());
                int active = 0;
                if (Boolean.TRUE.equals(block.getMediaActive())) {
                    active++;

                    vbOfBlock.item(BlockWithStrategy.MEDIA_ACTIVE).check(notNull());

                    if (Boolean.FALSE.equals(block.getMediaBlocked())) {
                        var defect = new Defect<>(BlockDefectIds.Strategy.ADS_CPM_VALUE_RANGE,
                                new StrategyDefectParams().withMaxCpm(MAX_CPM).withCpmName("media_cpm"));
                        vbOfBlock.item(BlockWithStrategy.MEDIA_CPM)
                                .check(notNull(), defect)
                                .check(inRange(MIN_CPM, MAX_CPM), defect, When.isValid())
                                .check(PartnerNumberConstraints.maxScale(CoreConstants.CPM_MAX_SCALE), defect);
                    } else if (Boolean.TRUE.equals(block.getMediaBlocked())) {
                        vbOfBlock.item(BlockWithStrategy.MEDIA_CPM)
                                .check(isNull());
                    }
                }
                if (Boolean.TRUE.equals(block.getTextActive())) {
                    active++;

                    vbOfBlock.item(BlockWithStrategy.TEXT_ACTIVE).check(notNull());

                    if (Boolean.FALSE.equals(block.getTextBlocked())) {
                        var defect = new Defect<>(BlockDefectIds.Strategy.ADS_CPM_VALUE_RANGE,
                                new StrategyDefectParams().withMaxCpm(MAX_CPM).withCpmName("text_cpm"));
                        vbOfBlock.item(BlockWithStrategy.TEXT_CPM)
                                .check(notNull(), defect)
                                .check(inRange(MIN_CPM, MAX_CPM), defect, When.isValid())
                                .check(PartnerNumberConstraints.maxScale(CoreConstants.CPM_MAX_SCALE), defect);
                    } else if (Boolean.TRUE.equals(block.getTextBlocked())) {
                        vbOfBlock.item(BlockWithStrategy.TEXT_CPM)
                                .check(isNull());
                    }
                }

                var mediaAndTextBlocked = Boolean.TRUE.equals(block.getMediaBlocked())
                        && Boolean.TRUE.equals(block.getTextBlocked());

                if (isVideoAllowed) {
                    if (Boolean.TRUE.equals(block.getVideoActive())) {
                        active++;

                        vbOfBlock.item(BlockWithStrategy.VIDEO_ACTIVE).check(notNull());

                        if (Boolean.FALSE.equals(block.getVideoBlocked())) {
                            var defect = new Defect<>(BlockDefectIds.Strategy.ADS_CPM_VALUE_RANGE,
                                    new StrategyDefectParams().withMaxCpm(MAX_CPM).withCpmName("video_cpm"));
                            vbOfBlock.item(BlockWithStrategy.VIDEO_CPM)
                                    .check(notNull(), defect)
                                    .check(inRange(MIN_CPM, MAX_CPM), defect, When.isValid())
                                    .check(PartnerNumberConstraints.maxScale(CoreConstants.CPM_MAX_SCALE), defect);
                        } else if (Boolean.TRUE.equals(block.getVideoBlocked())) {
                            vbOfBlock.item(BlockWithStrategy.VIDEO_CPM)
                                    .check(isNull());
                        }

                        if (mediaAndTextBlocked && Boolean.TRUE.equals(block.getVideoBlocked())) {
                            vbOfBlock.check(b ->
                                    new Defect<>(BlockDefectIds.Strategy.ALL_ADS_BLOCKED), When.isValid());
                        }
                    }

                } else {
                    vbOfBlock.item(BlockWithStrategy.VIDEO_ACTIVE).check(isNull());
                    vbOfBlock.item(BlockWithStrategy.VIDEO_BLOCKED).check(isNull());
                    vbOfBlock.item(BlockWithStrategy.VIDEO_CPM).check(isNull());

                    if (mediaAndTextBlocked) {
                        vbOfBlock.check(b ->
                                new Defect<>(BlockDefectIds.Strategy.ALL_ADS_BLOCKED), When.isValid());
                    }
                }

                if (active == 0) {
                    vbOfBlock.check(b -> new Defect<>(BlockDefectIds.Strategy.NOT_ACTIVE_ADS),
                            When.isValid());
                }
            }
            return vbOfBlock.getResult();
        };
    }

    private void allNull(ModelItemValidationBuilder<BlockWithStrategy> vbOfBlockStrategy,
                         List<ModelProperty<BlockWithStrategy, ?>> modelProperties) {
        for (ModelProperty<BlockWithStrategy, ?> modelProperty : modelProperties) {
            vbOfBlockStrategy.item(modelProperty).check(isNull());
        }
    }
}
