package ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy

import org.springframework.stereotype.Component
import ru.yandex.direct.model.AppliedChanges
import ru.yandex.partner.core.CoreConstants
import ru.yandex.partner.core.block.BlockType
import ru.yandex.partner.core.entity.block.container.BlockContainer
import ru.yandex.partner.core.entity.block.model.BaseBlock
import ru.yandex.partner.core.entity.block.model.BlockWithCommonShowVideoAndStrategy
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade

@Component
class BlockWithShowVideoAndStrategyUpdateOperationTypeSupport(
    _repositoryFacade: PartnerRepositoryTypeSupportFacade<BaseBlock, BlockType, BlockContainer, BlockContainer>
) : AbstractBlockUpdateOperationTypeSupport<BlockWithCommonShowVideoAndStrategy>(_repositoryFacade) {
    override fun getTypeClass(): Class<BlockWithCommonShowVideoAndStrategy> {
        return BlockWithCommonShowVideoAndStrategy::class.java
    }

    override fun onChangesApplied(
        updateContainer: BlockContainer?,
        appliedChanges: MutableList<AppliedChanges<BlockWithCommonShowVideoAndStrategy>>
    ) {
        // Исправление бага
        // TODO: PI-27639
        appliedChanges
            .filter {
                it.changed(BlockWithCommonShowVideoAndStrategy.SHOW_VIDEO)
                    && !it.model.showVideo
                    && it.model.strategyType == CoreConstants.Strategies.SEPARATE_CPM_STRATEGY_ID
            }
            .forEach {
                it.modify(BlockWithCommonShowVideoAndStrategy.VIDEO_ACTIVE, null)
                it.modify(BlockWithCommonShowVideoAndStrategy.VIDEO_BLOCKED, null)
                it.modify(BlockWithCommonShowVideoAndStrategy.VIDEO_CPM, null)
            }
    }
}
