package ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy;

import java.util.Arrays;
import java.util.Set;

import org.jetbrains.annotations.Nullable;

import ru.yandex.partner.core.messages.SiteVersionMsg;
import ru.yandex.partner.libs.i18n.GettextMsg;

import static java.util.stream.Collectors.toSet;

public enum SiteVersionType {
    AMP("amp", SiteVersionMsg.AMP_PAGES, "amp"),
    DESKTOP("desktop", SiteVersionMsg.DESKTOP),
    GENERAL("general", SiteVersionMsg.DESKTOP_OR_MOBILE),
    MOBILE("mobile", SiteVersionMsg.MOBILE),
    TURBO("turbo", SiteVersionMsg.TURBO_PAGES, "turbo"),
    MOBILE_FULLSCREEN("mobile_fullscreen", SiteVersionMsg.MOBILE_FULLSCREEN, "fullscreen"),
    MOBILE_REWARDED("mobile_rewarded", SiteVersionMsg.MOBILE_REWARDED, "rewarded"),
    MOBILE_FLOORAD("mobile_floorad", SiteVersionMsg.MOBILE_FLOOR_ADD),
    TURBO_DESKTOP("turbo_desktop", SiteVersionMsg.TURBO_PAGES_DESKTOP, "turbo-desktop");

    private final String literal;
    private final GettextMsg gettextMsg;
    private String pageImpOption;

    SiteVersionType(String literal, GettextMsg gettextMsg) {
        this.literal = literal;
        this.gettextMsg = gettextMsg;
    }

    SiteVersionType(String literal, GettextMsg gettextMsg, String pageImpOption) {
        this(literal, gettextMsg);
        this.pageImpOption = pageImpOption;
    }

    public String getLiteral() {
        return literal;
    }

    public GettextMsg getGettextMsg() {
        return gettextMsg;
    }

    @Nullable
    public String getPageImpOption() {
        return pageImpOption;
    }

    public static Set<String> literals(SiteVersionType... types) {
        return Arrays.stream(types)
                .map(SiteVersionType::getLiteral)
                .collect(toSet());
    }
}
