package ru.yandex.partner.core.entity.block.type.createdate;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithCreateDate;
import ru.yandex.partner.core.entity.block.service.type.add.AbstractBlockAddOperationTypeSupport;
import ru.yandex.partner.defaultconfiguration.PartnerLocalDateTime;

@Component
public class BlockWithCreateDateAddOperationTypeSupport extends
        AbstractBlockAddOperationTypeSupport<BlockWithCreateDate> {

    @Override
    public void onDuplicate(BlockContainer addModelContainer, List<BlockWithCreateDate> models) {
        models.forEach(model -> model.setCreateDate(null));
    }

    @Override
    public void beforeExecution(BlockContainer addContainer, List<BlockWithCreateDate> models) {
        models.forEach(model -> model.setCreateDate(PartnerLocalDateTime.now()));
    }

    @Override
    public Class<BlockWithCreateDate> getTypeClass() {
        return BlockWithCreateDate.class;
    }
}
