package ru.yandex.partner.core.entity.block.type.createdate

import org.jooq.DSLContext
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.direct.jooqmapper.JooqMapper
import ru.yandex.direct.jooqmapper.JooqMapperBuilder
import ru.yandex.direct.jooqmapper.ReaderWriterBuilders
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator
import ru.yandex.direct.model.AppliedChanges
import ru.yandex.partner.core.entity.block.model.BlockWithCreateDate
import ru.yandex.partner.core.entity.block.model.prop.BlockWithCreateDateCreateDatePropHolder
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper
import ru.yandex.partner.core.operation.CoreModelProvider
import ru.yandex.partner.core.props.CoreModel
import ru.yandex.partner.core.props.ModelPropertyDefault
import ru.yandex.partner.dbschema.partner.Tables
import java.time.LocalDateTime

@Component
class BlockWithCreateDateRepositoryTypeSupport(
    @Autowired
    _dslContext: DSLContext,
) : AbstractBlockRepositoryTypeSupportWithMapper<BlockWithCreateDate>(_dslContext),
    CoreModelProvider<BlockWithCreateDate> {

    private val mapper: JooqMapper<BlockWithCreateDate> = JooqMapperBuilder.builder<BlockWithCreateDate>()
        .map(ReaderWriterBuilders.property(BlockWithCreateDateCreateDatePropHolder.CREATE_DATE,
            Tables.CONTEXT_ON_SITE_RTB.CREATE_DATE)).build()

    override fun getJooqMapper(): JooqMapper<BlockWithCreateDate> {
        return mapper
    }

    override fun getTypeClass(): Class<BlockWithCreateDate> {
        return BlockWithCreateDate::class.java
    }

    override fun processUpdate(updateHelperAggregator: UpdateHelperAggregator,
                               appliedChanges: Collection<AppliedChanges<BlockWithCreateDate>>) {
        //no update
    }

    override fun getCoreModel(): CoreModel<BlockWithCreateDate> {
        return DEFAULT_VALUES
    }

    companion object {
        val DEFAULT_VALUES: CoreModel<BlockWithCreateDate> = CoreModel.forClass(BlockWithCreateDate::class.java)
            .property(
                ModelPropertyDefault.forProperty<BlockWithCreateDate, LocalDateTime>(
                    BlockWithCreateDateCreateDatePropHolder.CREATE_DATE
                )
                    .mandatoryOnAdd { LocalDateTime.now() }
            )
            .build()
    }

}
