package ru.yandex.partner.core.entity.block.type.createdate;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithCreateDate;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;
import ru.yandex.partner.core.entity.common.validation.NullPropertiesValidatorProvider;

@Component
public class BlockWithCreateDateValidationTypeSupport extends AbstractBlockValidationTypeSupport<BlockWithCreateDate> {
    private final NullPropertiesValidatorProvider<BlockWithCreateDate> nullPropertiesValidatorProvider;

    @Autowired
    public BlockWithCreateDateValidationTypeSupport(
            NullPropertiesValidatorProvider<BlockWithCreateDate> nullPropertiesValidatorProvider) {
        this.nullPropertiesValidatorProvider = nullPropertiesValidatorProvider;
    }

    @Override
    public Class<BlockWithCreateDate> getTypeClass() {
        return BlockWithCreateDate.class;
    }

    @Override
    public ValidationResult<List<BlockWithCreateDate>, Defect>
    addPreValidate(BlockContainer container,
                   ValidationResult<List<BlockWithCreateDate>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(nullPropertiesValidatorProvider.addPreValidator(List.of(BlockWithCreateDate.CREATE_DATE)),
                        When.isTrue(container.getMode().creation()))
                .getResult();
    }
}
