package ru.yandex.partner.core.entity.block.type.custombkdata;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithCustomBkData;
import ru.yandex.partner.core.entity.block.service.type.add.AbstractBlockAddOperationTypeSupport;

@Component
@ParametersAreNonnullByDefault
public class BlockWithCustomBkDataAddOperationTypeSupport
        extends AbstractBlockAddOperationTypeSupport<BlockWithCustomBkData> {

    @Override
    public Class<BlockWithCustomBkData> getTypeClass() {
        return BlockWithCustomBkData.class;
    }

    @Override
    public void onPreValidated(BlockContainer addContainer, List<BlockWithCustomBkData> models) {
        for (BlockWithCustomBkData model : models) {
            if (model.getIsCustomBkData() == null) {
                model.setIsCustomBkData(false);
            }
        }
    }
}
