package ru.yandex.partner.core.entity.block.type.custombkdata;

import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithCustomBkDataAndDesignTemplates;
import ru.yandex.partner.core.entity.block.service.OperationMode;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;

@Component
public class BlockWithCustomBkDataAndDesignTemplatesValidationTypeSupport
        extends AbstractBlockValidationTypeSupport<BlockWithCustomBkDataAndDesignTemplates> {

    private final Validator<BlockWithCustomBkDataAndDesignTemplates, Defect> validator;

    @Autowired
    public BlockWithCustomBkDataAndDesignTemplatesValidationTypeSupport(
            BlockWithCustomBkDataAndDesignTemplatesValidatorProvider provider) {

        this.validator = provider.validator();
    }

    @Override
    public Class<BlockWithCustomBkDataAndDesignTemplates> getTypeClass() {
        return BlockWithCustomBkDataAndDesignTemplates.class;
    }

    @Override
    public ValidationResult<List<BlockWithCustomBkDataAndDesignTemplates>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithCustomBkDataAndDesignTemplates>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                // валидация при добавлении не требуется так как BkData не входит в состав AddFields
                // при дублировании id дизайнов устанавливаются позже этой операции
                .checkEachBy(validator, When.isTrue(
                        Set.of(OperationMode.CRON, OperationMode.EDIT).contains(container.getMode())))
                .getResult();
    }
}
