package ru.yandex.partner.core.entity.block.type.custombkdata;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithCustomBkDataFlag;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.utils.CommonConverters;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
@ParametersAreNonnullByDefault
public class BlockWithCustomBkDataFlagRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithCustomBkDataFlag> {
    private final JooqMapper<BlockWithCustomBkDataFlag> mapper;

    @Autowired
    protected BlockWithCustomBkDataFlagRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        this.mapper = createCommonBlockMapper();
    }

    private static JooqMapper<BlockWithCustomBkDataFlag> createCommonBlockMapper() {
        return JooqMapperBuilder.<BlockWithCustomBkDataFlag>builder()
                .map(convertibleProperty(BlockWithCustomBkDataFlag.IS_CUSTOM_BK_DATA,
                        CONTEXT_ON_SITE_RTB.IS_CUSTOM_BK_DATA,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .build();
    }

    @Override
    public JooqMapper<BlockWithCustomBkDataFlag> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithCustomBkDataFlag> getTypeClass() {
        return BlockWithCustomBkDataFlag.class;
    }

}
