package ru.yandex.partner.core.entity.block.type.custombkdata;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithCustomBkDataFlag;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;

@Component
public class BlockWithCustomBkDataFlagValidationTypeSupport
        extends AbstractBlockValidationTypeSupport<BlockWithCustomBkDataFlag> {

    private final Validator<BlockWithCustomBkDataFlag, Defect> validator;

    @Autowired
    public BlockWithCustomBkDataFlagValidationTypeSupport(
            BlockWithCustomBkDataFlagValidatorProvider validatorProvider) {

        this.validator = validatorProvider.validator();
    }

    @Override
    public Class<BlockWithCustomBkDataFlag> getTypeClass() {
        return BlockWithCustomBkDataFlag.class;
    }

    @Override
    public ValidationResult<List<BlockWithCustomBkDataFlag>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithCustomBkDataFlag>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }
}
