package ru.yandex.partner.core.entity.block.type.custombkdata;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithCustomBkDataFlag;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.partner.core.validation.defects.TypeDefects.invalidTypeMustBeBoolean;

@Component
public class BlockWithCustomBkDataFlagValidatorProvider {

    public <M extends BlockWithCustomBkDataFlag> Validator<M, Defect> validator() {
        return block -> {
            var vb = ModelItemValidationBuilder.of(block);
            vb.item(BlockWithCustomBkDataFlag.IS_CUSTOM_BK_DATA)
                    .check(notNull(), invalidTypeMustBeBoolean());
            return vb.getResult();
        };
    }
}
