package ru.yandex.partner.core.entity.block.type.custombkdata;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithCustomBkData;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
@ParametersAreNonnullByDefault
public class BlockWithCustomBkDataRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithCustomBkData> {
    private final JooqMapper<BlockWithCustomBkData> mapper;

    @Autowired
    protected BlockWithCustomBkDataRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        this.mapper = createCommonBlockMapper();
    }

    private static JooqMapper<BlockWithCustomBkData> createCommonBlockMapper() {
        return JooqMapperBuilder.<BlockWithCustomBkData>builder()
                .map(property(BlockWithCustomBkData.BK_DATA, CONTEXT_ON_SITE_RTB.BK_DATA))
                .build();
    }

    @Override
    public JooqMapper<BlockWithCustomBkData> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithCustomBkData> getTypeClass() {
        return BlockWithCustomBkData.class;
    }
}
