package ru.yandex.partner.core.entity.block.type.custombkdata;

import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithCustomBkData;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

@Component
public class BlockWithCustomBkDataUpdateOperationTypeSupport
        extends AbstractBlockUpdateOperationTypeSupport<BlockWithCustomBkData> {

    private static final Set<ModelProperty<? super BlockWithCustomBkData, ?>> NEED_UPDATE_IN_BK_FIELDS =
            Set.of(BlockWithCustomBkData.IS_CUSTOM_BK_DATA, BlockWithCustomBkData.BK_DATA);

    public BlockWithCustomBkDataUpdateOperationTypeSupport(PartnerRepositoryTypeSupportFacade<BaseBlock, BlockType,
            BlockContainer, BlockContainer> repositoryFacade) {
        super(repositoryFacade);
    }

    @Override
    public Class<BlockWithCustomBkData> getTypeClass() {
        return BlockWithCustomBkData.class;
    }

    @Override
    public Set<ModelProperty<? super BlockWithCustomBkData, ?>> needBsResyncProps() {
        return NEED_UPDATE_IN_BK_FIELDS;
    }
}
