package ru.yandex.partner.core.entity.block.type.custombkdata

import org.springframework.stereotype.Component
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.partner.core.entity.QueryOpts
import ru.yandex.partner.core.entity.block.container.BlockContainer
import ru.yandex.partner.core.entity.block.model.BlockWithCustomBkData
import ru.yandex.partner.core.entity.block.service.OperationMode
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport
import ru.yandex.partner.core.entity.block.type.dsps.BlockWithDspsRepositoryTypeSupport.DSP_PROPS_FOR_BLOCK
import ru.yandex.partner.core.entity.dsp.model.Dsp
import ru.yandex.partner.core.entity.dsp.service.DspService

@Component
class BlockWithCustomBkDataValidationTypeSupport(
    private val validatorProvider: BlockWithCustomBkDataValidatorProvider,
    private val dspService: DspService
) :
    AbstractBlockValidationTypeSupport<BlockWithCustomBkData>() {
    private val validator: Validator<BlockWithCustomBkData, Defect<*>>

    override fun getTypeClass(): Class<BlockWithCustomBkData> {
        return BlockWithCustomBkData::class.java
    }

    override fun fillContainer(container: BlockContainer, models: MutableList<BlockWithCustomBkData>) {
        if (container.dsps == null) {
            container.dsps = dspService.findAll(QueryOpts.forClass(Dsp::class.java).withProps(DSP_PROPS_FOR_BLOCK))
                .map { it as Dsp }
                .associateBy { it.id }
        }
    }

    override fun validate(
        container: BlockContainer,
        vr: ValidationResult<List<BlockWithCustomBkData>, Defect<*>>?
    ): ValidationResult<List<BlockWithCustomBkData>, Defect<*>> {
        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .checkEachBy(
                validatorProvider.validateBlockBkData(
                    container.dsps,
                    container::getIsValidatingBkData,
                    container.mode == OperationMode.CRON
                ), When.isValid()
            )
            .result
    }

    init {
        validator = validatorProvider.validator()
    }
}
