package ru.yandex.partner.core.entity.block.type.custombkoptions;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import NPartner.Page.TPartnerPage;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithCustomBkOptions;
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.entity.custombkoptions.CustomBkOptionsService;
import ru.yandex.partner.core.entity.custombkoptions.model.CustomBkOptions;
import ru.yandex.partner.core.multitype.repository.EmptyTypeSupportModifyStrategy;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;
import ru.yandex.partner.core.utils.CommonConverters;
import ru.yandex.partner.dbschema.partner.tables.ContextOnSiteRtb;

import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.convertibleJsonProperty;

@Component
@ParametersAreNonnullByDefault
public class BlockWithCustomBkOptionsRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithCustomBkOptions>
        implements CoreModelProvider<BlockWithCustomBkOptions>, BlockBkFiller<BlockWithCustomBkOptions> {

    private static final CoreModel<BlockWithCustomBkOptions> MODEL = CoreModel.forClass(BlockWithCustomBkOptions.class)
            .property(ModelPropertyDefault
                    .<BlockWithCustomBkOptions, List<Long>>forProperty(BlockWithCustomBkOptions.CUSTOM_BK_OPTIONS)
                    .withDefaultValueOnAdd(List.of()))
            .build();

    private final JooqMapper<BlockWithCustomBkOptions> mapper;
    private final CustomBkOptionsService customBkOptionsService;

    @Autowired
    public BlockWithCustomBkOptionsRepositoryTypeSupport(DSLContext dslContext,
                                                         CustomBkOptionsService customBkOptionsService,

                                                         ObjectMapper objectMapper) {
        super(dslContext, new EmptyTypeSupportModifyStrategy<>());
        this.customBkOptionsService = customBkOptionsService;
        this.mapper = JooqMapperBuilder.<BlockWithCustomBkOptions>builder()
                .map(convertibleJsonProperty(
                        BlockWithCustomBkOptions.CUSTOM_BK_OPTIONS,
                        ContextOnSiteRtb.CONTEXT_ON_SITE_RTB.OPTS,
                        "custom_bk_options",
                        value -> CommonConverters.jsonNodeToList(objectMapper, value, Long.class),
                        value -> CommonConverters.listToJsonNode(objectMapper, value)
                ))
                .build();
    }

    @Override
    public void fillBkData(@NotNull BlockWithCustomBkOptions block,
                           @NotNull TPartnerPage.TBlock.Builder bkData, BlockBkDictContainer container) {
        if (block.getCustomBkOptions() == null) {
            return;
        }

        List<CustomBkOptions> options = container.customBkOptions.stream()
                .filter(opt -> block.getCustomBkOptions().contains(opt.getId()))
                .collect(Collectors.toList());

        String customBlockData = bkData.getCustomBlockData();
        for (var option : options) {
            customBlockData = customBkOptionsService.setOption(customBlockData, option);
        }

        bkData.setCustomBlockData(customBlockData);
    }

    @Override
    public JooqMapper<BlockWithCustomBkOptions> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithCustomBkOptions> getTypeClass() {
        return BlockWithCustomBkOptions.class;
    }

    @Override
    public CoreModel<BlockWithCustomBkOptions> getCoreModel() {
        return MODEL;
    }
}
