package ru.yandex.partner.core.entity.block.type.custombkoptions;

import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithCustomBkOptions;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

@Component
public class BlockWithCustomBkOptionsUpdateOperationTypeSupport
        extends AbstractBlockUpdateOperationTypeSupport<BlockWithCustomBkOptions> {

    private static final Set<ModelProperty<? super BlockWithCustomBkOptions, ?>> NEED_UPDATE_IN_BK_FIELDS = Set.of(
            BlockWithCustomBkOptions.CUSTOM_BK_OPTIONS
    );

    @Autowired
    public BlockWithCustomBkOptionsUpdateOperationTypeSupport(
            PartnerRepositoryTypeSupportFacade<BaseBlock, BlockType, BlockContainer, BlockContainer> repositoryFacade) {
        super(repositoryFacade);
    }

    @Override
    public Class<BlockWithCustomBkOptions> getTypeClass() {
        return BlockWithCustomBkOptions.class;
    }

    @Override
    public Set<ModelProperty<? super BlockWithCustomBkOptions, ?>> needBsResyncProps() {
        return NEED_UPDATE_IN_BK_FIELDS;
    }
}
