package ru.yandex.partner.core.entity.block.type.designtemplates;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.NotImplementedException;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDesignTemplatesAndDependsFields;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;


@ParametersAreNonnullByDefault
public abstract class AbstractBlockWithDesignTemplatesAndDependsFieldsValidationTypeSupport
        <M extends BlockWithDesignTemplatesAndDependsFields> extends AbstractBlockValidationTypeSupport<M> {

    private final BlockWithDesignTemplatesAndDependsFieldsValidatorProvider validatorProvider;

    public AbstractBlockWithDesignTemplatesAndDependsFieldsValidationTypeSupport(
            BlockWithDesignTemplatesAndDependsFieldsValidatorProvider provider) {

        this.validatorProvider = provider;
    }

    @Override
    public void fillContainer(BlockContainer container, List<M> models) {
        throw new NotImplementedException("You have to implement validation for design templates for your model");
    }

    @Override
    public ValidationResult<List<M>, Defect> addPreValidate(BlockContainer container, ValidationResult<List<M>,
            Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.addPreValidator(), When.isTrue(container.getMode().creation()))
                .getResult();
    }

    @Override
    public ValidationResult<List<M>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<M>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.validator(container))
                .getResult();
    }
}
