package ru.yandex.partner.core.entity.block.type.designtemplates;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.QueryOpts;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.PageWithOwner;
import ru.yandex.partner.core.entity.page.service.PageService;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.feature.UserFeatureEnum;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.core.service.entitymanager.EntityManager;

@Component
public class BlockContainerFiller {
    private final PageService pageService;
    private final EntityManager entityManager;

    public BlockContainerFiller(PageService pageService, EntityManager entityManager) {
        this.pageService = pageService;
        this.entityManager = entityManager;
    }

    public void fillFeaturesAndOptions(BlockContainer container, List<? extends BaseBlock> models) {
        if (models.isEmpty()) {
            return;
        }

        var pageIdsToCollect = StreamEx.of(models)
                .map(BaseBlock::getPageId)
                .collect(Collectors.toSet());

        var pageClazz = entityManager.getPageClassByBlockClass(models.get(0).getClass(), PageWithOwner.class);
        MetaFilter<BasePage, Long> filter = PageFilters.PAGE_ID;

        var coreFilterNode = CoreFilterNode.in(filter, pageIdsToCollect);

        var pageModelProperties = Set.of(
                PageWithOwner.ID,
                PageWithOwner.OWNER
        );

        var pages = pageService.findAll(
                QueryOpts.forClass(pageClazz)
                        .withFilter(coreFilterNode)
                        .withProps(pageModelProperties)
        );

        var featuresAndOptionsToAdd = StreamEx.of(pages)
                .toMap(BasePage::getId, it -> getUserFeatures(it.getOwner()));

        container.setFeaturesAndOptions(featuresAndOptionsToAdd);
    }

    public static Set<String> getUserFeatures(User user) {
        var features =  Optional.of(user)
                .map(User::getFeatures)
                .map(HashSet::new)
                .orElse(new HashSet<>());

        var allowedDesignAuctionNativeOnly = Optional.of(user)
                .map(User::getAllowedDesignAuctionNativeOnly)
                .orElse(false);

        if (allowedDesignAuctionNativeOnly) {
            features.add(UserFeatureEnum.ALLOWED_DESIGN_AUCTION_NATIVE_ONLY.getFeatureName());
        }

        return features;
    }
}
